/******************************************************/
/* Examples Program For "ET-BASE dsPIC30F4011"  Board */
/* Hardware    : ET-BASE dsPIC30F4011                 */
/* Target MCU  : dsPIC30F4011                         */
/*       	   : X-TAL : 7.3728 MHz                   */
/*             : Run 117.9648MHz                      */
/*             : Selec OSC Mode = XT w/PLL 16x        */
/* Compiler    : MPLAB v8.40 + C30 v3.20B      	      */
/* Last Update : 12/October/2009                      */
/******************************************************/
/* Function    : Example Use UART2 = 9600 BPS         */
/******************************************************/
/******************************************************/
/* UART2                                              */
/* -> Used RF5  = TXD2                                */
/* -> Used RF4  = RXD2                                */
/******************************************************/

#include <p30f4011.h>                                		// dsPIC30F4011 MPU Register
#include <stdio.h>											// Used "sprintf" Function
#include "uart.h"											// Used UART Config

/* Setup Configuration For ET-BASE dsPIC30F4011 */
_FOSC(CSW_FSCM_OFF & XT_PLL16);								// Disable Clock Switching,Enable Fail-Salf Clock
                                                            // Clock Source = Primary XT + (PLL x 16)
_FWDT(WDT_OFF);												// Disable Watchdog 
_FBORPOR(PBOR_OFF & PWRT_64 & MCLR_EN);					    // Disable Brown-Out ,Power ON = 64mS,Enable MCLR
_FGS(CODE_PROT_OFF);										// Code Protect OFF
/* End   Configuration For ET-BASE dsPIC30F4011 */

char uart_buf2[40]; 										// "sprintf" Buffer

/* pototype  section */
void init_uart2(void);										// Initial UART2 Function

int main(void)
{  
  char rx_data;												// Character Receive Buffer

  init_uart2();												// Initial UART = 9600,N,8,1


  //UART1 Menu Test
  sprintf(uart_buf2,"\n\r\n\r\n\r\n\r");		
  putsUART2((unsigned int *)uart_buf2);                     
  while(BusyUART2());	
  sprintf(uart_buf2,"*******************************\n\r");		
  putsUART2((unsigned int *)uart_buf2);                     
  while(BusyUART2());										
  sprintf(uart_buf2,"ET-BASE dsPIC30F4011 Demo UART2\n\r"); 	
  putsUART2((unsigned int *)uart_buf2);                     
  while(BusyUART2());										
  sprintf(uart_buf2,"*******************************\n\r");		
  putsUART2((unsigned int *)uart_buf2);                    
  while(BusyUART2());				

  while(1)													// Loop Continue
  {
    if (DataRdyUART2())										// If RX Receive Complete
    {
      rx_data = ReadUART2();								// Get UART Data Receive
      if (rx_data == 0x0D)									// If Receive Enter
      {
        sprintf(uart_buf2,"UART2(RS232)\n\r");				// Print Message String 
        putsUART2((unsigned int *)uart_buf2);               // Print uart_buff to UART
        while(BusyUART2());									// Wait putsUART Complete  
      } 
      putcUART2(rx_data);									// Echo to TX of UART
      while(BusyUART2());									// Wait putcUART Complete  
    }
  } 
}	  


/*********************************/
/* Initial UART for dsPIC30F4011 */
/* 9600,N,8,1 / 117.9648MHz Fosc */
/*********************************/
void init_uart2()
{		  
  CloseUART2();												// Disable UART2 Before New Config

  // Config UART2 Interrupt Control
  ConfigIntUART2(UART_RX_INT_DIS &							// Disable RX Interrupt
    		     UART_RX_INT_PR2 &							// RX Interrupt Priority = 2
    		     UART_TX_INT_DIS &							// Disable TX Interrupt
    		     UART_TX_INT_PR3);							// TX Interrupt Priority = 3  
  // Open UART2 = Mode,Status,Baudrate              
  OpenUART2(UART_EN	&										// Enable UART(UART Mode)
            UART_IDLE_STOP &								// Disable UART in IDLE Mode 
            UART_DIS_WAKE &									// Disable Wake-Up
			UART_DIS_LOOPBACK &								// Disable Loop Back
			UART_DIS_ABAUD &								// Disable Auto Baudrate
  			UART_NO_PAR_8BIT &								// UART = 8 Bit, No Parity
 			UART_1STOPBIT,									// UART = 1 Stop Bit

	  		// Config UART1 Status
  			UART_INT_TX & 									// Select Interrupt After TX Complete
	 		UART_TX_PIN_NORMAL &							// Normal U1TX Mode
 			UART_TX_ENABLE &								// Enable U1TX
 	 		UART_INT_RX_BUF_FUL &							// Flasg Set After RX Complete 
  			UART_ADR_DETECT_DIS &              				// Disable Check Address 
			UART_RX_OVERRUN_CLEAR,							// Clear Overrun Flag

  			// ET-BASE dsPIC30F4011 Hardware Board
  			// XTAL = 7.3728MHz
  			// Fosc = 7.3728 MHz x 16 = 117.9648 MHz
  			// Fcy(UART) = Fosc / 4 
  			//           = 117.9648 / 4 = 29.4912 MHz
  			// U1BRG = [Fcy/(16xBaud)]-1
  			//       = [29.4912 MHz / (16x9600)] - 1
  			//       = 191 = BFH			
  			191);											// ET-BASE dsPIC30F4011 UART Baudrate = 9600 BPS
}
